import pandas as pd   
import matplotlib.pyplot as plt   
import seaborn as sns
from decision_company import read_csv_file, create_histogram, create_figure, set_plot_xlabel, create_figure, set_plot_title, set_yaxis_label, show_plots, save_plot

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Distribution plot for age  
create_figure((10, 6))  
create_histogram(data=credit_customers, x='age', kde=True, bins=20)  
set_plot_title("Age Distribution")  
set_plot_xlabel("Age")  
set_yaxis_label("Frequency")  
save_plot('./ref_result/histplot.png')  
show_plots()   
